clear all

* Set Folder to output one

cd ..\Outputs

* Call dataset of revisions and shocks combined (COMB)

use COMB, clear

gen time=year+(qua-1)/4
egen t=group(year quarter)
tsset t

capture drop MPOa
gen MPOa=MPO
replace MPOa=0 if MPO==. & year>2008

gen dlogY=log(GDPC96/l.GDPC96)*400

* Dummy variable for the Great Recession

gen DGR=(time==2008 | time==2008.25 | time==2008.5 | time==2008.75 | time==2009 | time==2009.25)

*===============================================================================
*			      Variables with contemporanous response
*===============================================================================

quiet foreach var in TFP sFP1SPF1 FP2 DE1 OILK  {
	
	noisily di "====================================================="
	noisily di "			`var'"
	noisily di "====================================================="
	
	* Define strings for titles of IRF figures
	
	if "`var'"=="TFP" local var_str="TFP shock (Fernald)"
	if "`var'"=="sFP1SPF1" local var_str="Gov't spending shock (AG 2012)"
	if "`var'"=="DE1" local var_str="Military spending shock (Ramey 2016)"
	if "`var'"=="DE2" local var_str="Military spending shock (Ramey 2016)"
	if "`var'"=="OIL" local var_str="Oil supply shock (Kilian 2004)"
	if "`var'"=="OILK" local var_str="Oil supply shock (Kilian 2009)"
	if "`var'"=="FP2" local var_str="Tax shock (Romer and Romer 2010)"
	
	if "`var'"=="OILK" {	
		* local str_legend="order(2 1 3 4) label(1 90% CI) label(2 Actual Output (8yr MA)) label(3 Potential Output) label(4 90% CI) rows(2) ring(0) position(7)"
		local str_legend="order(2 1 3 4 5 6 ) label(1 90% CI) label(2 Potential Output) label(3 Actual 2yr MA) label(4 Actual 5yr MA)  label(5 Actual 8yr MA)  label(6 Actual 10yr MA) rows(3) ring(0) position(7)"
	}
	else {
		local str_legend="off"
	}
	
	if "`var'"=="TFP" local str_yaxis="-1(1)3"
	if "`var'"=="sFP1SPF1" local str_yaxis="-2(1)2"
	if "`var'"=="DE1" local str_yaxis="-1(1)2"
	if "`var'"=="OILK" local str_yaxis="-3(1)1"
	if "`var'"=="FP2" local str_yaxis="-2(1)1"
	
	capture drop Z*
	gen Z=`var'
	sum Z
	replace Z=Z/r(sd)
	
	* Create current and lagged values of the shock
	
	forvalues i=0(1)8 {
		gen Z`i'=l`i'.Z
	}
	
	reg GREgRpot0 dlogY Z?
	capture drop smpl0
	gen smpl0=e(sample)
	drop Z
	
	capture drop irf*
	*** time for IRFs
	gen irf_0=t-1
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				          IRF for potential output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey GREgRpot0 Z* D911 DGR if smpl0==1, lag(4)
	
	gen irf_pot_m=.
	gen irf_pot_se=.
	local str0="Z0"
	lincom "`str0'"
	replace irf_pot_m=r(estimate) if irf_0==0
	replace irf_pot_se=r(se) if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_pot_m=r(estimate) if irf_0==`i'
		replace irf_pot_se=r(se) if irf_0==`i'
	}	
	
	gen irf_pot_m_up=irf_pot_m+1.65*irf_pot_se
	gen irf_pot_m_lo=irf_pot_m-1.65*irf_pot_se
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				           IRF for actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	foreach hh in 8 20 32 40 {
		capture drop dlogY
		gen dlogY=maGY`hh'
		replace dlogY=(l.dlogY+f.dlogY)/2 if dlogY==. & f.dlogY~=. & l.dlogY~=.

		newey dlogY Z* D911 DGR if smpl0==1, lag(4)

		gen irf_act`hh'_m=.
		gen irf_act`hh'_se=.	
		local str0="Z0"
		lincom "`str0'"
		replace irf_act`hh'_m=r(estimate) if irf_0==0
		replace irf_act`hh'_se=r(se) if irf_0==0
			
		forvalues i=1(1)8 {
			local str0="`str0'" + "+Z`i'" 
			lincom "`str0'"
			replace irf_act`hh'_m=r(estimate) if irf_0==`i'
			replace irf_act`hh'_se=r(se) if irf_0==`i'
		}		
			
		gen irf_act`hh'_m_up=irf_act`hh'_m+1.65*irf_act`hh'_se
		gen irf_act`hh'_m_lo=irf_act`hh'_m-1.65*irf_act`hh'_se		
	}

	twoway ///
	(rarea irf_pot_m_lo irf_pot_m_up irf_0 if irf_0<=8, color(gs14)) ///
	(line irf_pot_m  irf_0 if irf_0<=8, lcolor(black) lpattern(solid) lwidth(thick)) ///
	(line irf_act8_m  irf_0 if irf_0<=8, lcolor(blue) lpattern(solid)) ///
	(line irf_act20_m  irf_0 if irf_0<=8, lcolor(green) lpattern(dash)) ///
	(line irf_act32_m  irf_0 if irf_0<=8, lcolor(orange) lpattern(shortdash)) ///
	(line irf_act40_m  irf_0 if irf_0<=8, lcolor(red) lpattern(longdash)) ///		
	, ///
	xtitle("") xlabel(0(1)8)  ylabel("`str_yaxis'")  ///
	ytitle("output growth rate, percent, annualized") ///
	title("`var_str'") ///
	legend(`str_legend') ///
	graphregion(color(white)) bgcolor(white) ///				
	name(`var', replace)
				
}

*===============================================================================
*			        Variables with NO contemporanous response
*===============================================================================

quiet foreach var in MPOa MPVAR0 {
	noisily di "====================================================="
	noisily di "			`var'"
	noisily di "====================================================="
	
	if "`var'"=="MPOa" local var_str="Monetary policy shock (Romer and Romer 2004)"
	if "`var'"=="MPVAR0" local var_str="Monetary policy shock (VAR)"
	
	if "`var'"=="MPOa" local str_yaxis="-2(1)1"
	if "`var'"=="MPVAR0" local str_yaxis="-3(1)1"
	
	capture drop Z*
	gen Z=`var'
	sum Z
	replace Z=Z/r(sd)
	
	* Create current and lagged values of the shock
	
	forvalues i=1(1)8 {
		gen Z`i'=l`i'.Z
	}
	
	reg GREgRpot0 dlogY Z?
	capture drop smpl0
	gen smpl0=e(sample)
	drop Z
	
	capture drop irf*
	*** time for IRFs
	gen irf_0=t-1
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*			          	IRF for potential output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey GREgRpot0 Z* D911 DGR if smpl0==1, lag(4)
	
	gen irf_pot_m=.
	gen irf_pot_se=.
	local str0="0"
	
	replace irf_pot_m=0 if irf_0==0
	replace irf_pot_se=0 if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_pot_m=r(estimate) if irf_0==`i'
		replace irf_pot_se=r(se) if irf_0==`i'
	}	
	
	gen irf_pot_m_up=irf_pot_m+1.65*irf_pot_se
	gen irf_pot_m_lo=irf_pot_m-1.65*irf_pot_se
	
	*** test cumulative sum for the potential is zero
	lincom Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_pot_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f") 
	
	*** test pointwise that the potential output IRF (growth rate) is zero for the growth rate
	test Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_pot_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				       IRF for actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	foreach hh in 8 20 32 40 {
		capture drop dlogY
		gen dlogY=maGY`hh'
		replace dlogY=(l.dlogY+f.dlogY)/2 if dlogY==. & f.dlogY~=. & l.dlogY~=.
		
		newey dlogY Z* D911 DGR if smpl0==1, lag(4)

		gen irf_act`hh'_m=.
		gen irf_act`hh'_se=.	
		local str0="0"
		replace irf_act`hh'_m=0 if irf_0==0
		replace irf_act`hh'_se=0 if irf_0==0
			
		forvalues i=1(1)8 {
			local str0="`str0'" + "+Z`i'" 
			lincom "`str0'"
			replace irf_act`hh'_m=r(estimate) if irf_0==`i'
			replace irf_act`hh'_se=r(se) if irf_0==`i'
		}		
			
		gen irf_act`hh'_m_up=irf_act`hh'_m+1.65*irf_act`hh'_se
		gen irf_act`hh'_m_lo=irf_act`hh'_m-1.65*irf_act`hh'_se		
	}

	local str_legend="off"

	twoway ///
	(rarea irf_pot_m_lo irf_pot_m_up irf_0 if irf_0<=8, color(gs14)) ///
	(line irf_pot_m  irf_0 if irf_0<=8, lcolor(black) lpattern(solid) lwidth(thick)) ///
	(line irf_act8_m  irf_0 if irf_0<=8, lcolor(blue) lpattern(solid)) ///
	(line irf_act20_m  irf_0 if irf_0<=8, lcolor(green) lpattern(dash)) ///
	(line irf_act32_m  irf_0 if irf_0<=8, lcolor(orange) lpattern(shortdash)) ///
	(line irf_act40_m  irf_0 if irf_0<=8, lcolor(red) lpattern(longdash)) ///		
	, ///
	xtitle("") xlabel(0(1)8)  ylabel("`str_yaxis'")  ///
	ytitle("output growth rate, percent, annualized") ///
	title("`var_str'") ///
	legend(`str_legend') ///
	graphregion(color(white)) bgcolor(white) ///				
	name(`var', replace)
		
}

window manage close graph _all
graph combine TFP FP2 OILK, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) t1title(Panel A: Supply Shocks) name(panela, replace)
graph combine MPOa DE1 sFP1SPF1, rows(1) ysize(2) graphregion(color(white)) plotregion(color(white)) t1title(Panel B: Demand Shocks) name(panelb, replace)

window manage close graph _all
graph combine panela panelb, rows(2) altshrink graphregion(color(white)) plotregion(color(white))
